using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;

namespace hiveAdiz
{
	public class AdizDeveloperTool
	{
		
	#if UNITY_ANDROID && !UNITY_EDITOR

		private static AndroidJavaObject currentActivity = null;
		private static AndroidJavaClass hiveAdizPlugin = new AndroidJavaClass("com.hive.adiz.utils.AdizDeveloperTool"); 

		public static void OpenAdInspector() {
			AdizLogger.d("AdizDeveloperTool OpenAdInspector");

			AndroidJavaClass jc = new AndroidJavaClass("com.unity3d.player.UnityPlayer");
			currentActivity = jc.GetStatic<AndroidJavaObject>("currentActivity");

			hiveAdizPlugin.CallStatic("openAdInspector", currentActivity);
		}

	#elif UNITY_IOS && !UNITY_EDITOR

		[DllImport("__Internal")]
		private static extern void AdizDeveloperTool_OpenAdInspector();

		public static void OpenAdInspector() {
			AdizLogger.d("AdizDeveloperTool OpenAdInspector");
			AdizDeveloperTool_OpenAdInspector();
		}

	#else

		public static void OpenAdInspector() {
			AdizLogger.d("AdizDeveloperTool OpenAdInspector");
		}
		
	#endif
		
	}
}